prompt $G

rem  motifexs.bat - Examples for TEXTURE MOTIFS/IN
rem infile: marimba.wav (0.99 sec)
rem note data files: ndfmot1.txt, ndfmot2.txt
rem breakpoint files: none

rem  A Endrich - last updated: 13 November 2000 

rem ... ndf outdur packing scatter tgrid
rem snd1st sndlast ming maxg minp maxp
rem phgrid grpspace gpsprange amprise contour multlo multhi
rem [-aatten -pposition -sspread -rseed -w -d -i]

echo on

set CDP_SOUND_EXT=wav

rem EXAMPLE 1 - Mode 5 - a defined motif plays on pitches randomly 
rem	selected from a pitch range
rem ndfmot1.txt
rem 60
rem #10				(motif)
rem 0.0 1 60 70 0.3
rem 0.1 1 61 50 0.3
rem 0.2 1 66 50 0.3
rem 0.3 1 67 50 0.3
rem 0.4 1 66 70 0.3
rem 0.5 1 67 60 0.3
rem 0.6 1 70 60 0.3
rem 0.7 1 66 60 0.3
rem 0.8 1 72 80 0.3
rem 0.9 1 66 50 0.3

texture motifs 5 marimba motifex1 ndfmot1.txt 12 1 0 0 1 1 30 90 48 84 0 1 1 0 0 1 1


rem EXAMPLE 2a/b/c - Mode 3 - a defined motif plays on a random selection from 
rem	the notes of a defined harmonic set at varying tempos.  Hear what 
rem	happens with the 'b' version (MOTIFSIN) of the same parameters.  
rem	The 'c' version creates overlaps with a skiptime of 0.25.
rem ndfmot2.txt
rem 60
rem #9				(Harmonic Field/Set)
rem 0.0 1 60 0 0
rem 0.0 1 61 0 0
rem 0.0 1 63 0 0
rem 0.0 1 64 0 0
rem 0.0 1 66 0 0
rem 0.0 1 67 0 0
rem 0.0 1 68 0 0
rem 0.0 1 70 0 0
rem 0.0 1 72 0 0
rem #10				(motif)
rem 0.0 1 60 70 0.3
rem 0.1 1 61 50 0.3
rem 0.2 1 66 50 0.3
rem 0.3 1 67 50 0.3
rem 0.4 1 66 50 0.3
rem 0.5 1 67 70 0.3
rem 0.6 1 70 50 0.3
rem 0.7 1 66 50 0.3
rem 0.8 1 72 80 0.3
rem 0.9 1 66 60 0.3

texture motifs   3 marimba motifex2a ndfmot2.txt 12 1    0 0 1 1 30 90 48 84 0 1 1 0 0 0.5 2
texture motifsin 3 marimba motifex2b ndfmot2.txt 12 1    0 0 1 1 30 90 48 84 0 1 1 0 0 0.5 2
texture motifs   3 marimba motifex2c ndfmot2.txt 12 0.25 0 0 1 1 30 90 48 84 0 1 1 0 0 0.5 2


rem EXAMPLE 3a/b/c - two inputs (marimba & horn) and two motifs;  the 'b' 
rem	version has a 1/2 sec overlap, with no tempo variation.  The 'c' 
rem	version uses Mode 1 which opens up different octaves.
rem ndfmot3.txt
rem 59 60
rem #9				(Harmonic Field/Set)
rem 0.0 1 60 0 0
rem 0.0 1 61 0 0
rem 0.0 1 63 0 0
rem 0.0 1 64 0 0
rem 0.0 1 66 0 0
rem 0.0 1 67 0 0
rem 0.0 1 68 0 0
rem 0.0 1 70 0 0
rem 0.0 1 72 0 0
rem #10				(motif 1)
rem 0.0 1 60 70 0.3
rem 0.1 1 61 50 0.3
rem 0.2 1 66 50 0.3
rem 0.3 1 67 50 0.3
rem 0.4 1 66 50 0.3
rem 0.5 1 67 70 0.3
rem 0.6 1 70 50 0.3
rem 0.7 1 66 50 0.3
rem 0.8 1 72 80 0.3
rem 0.9 1 66 60 0.3
rem #3				(motif 2)
rem 0.0  1 60 40 1.5 
rem 0.34 1 67 45 1.5 
rem 0.67 1 72 50 1.5 

texture motifs 3 marimba horn motifex3a ndfmot3.txt 12 1.0 0 0 1 2 30 90 48 84 0 1 1 0 0 0.5 2
texture motifs 3 marimba horn motifex3b ndfmot3.txt 12 0.5 0 0 1 2 30 90 48 84 0 1 1 0 0 1 1
texture motifs 1 marimba horn motifex3c ndfmot3.txt 12 0.5 0 0 1 2 30 90 48 84 0 1 1 0 0 1 1

rem EXAMPLE 4 - uses Mode 4 to illustrate how the start pitches of the 
rem	motifs can be controlled by timing information in the Harmonic 
rem	Field/Set.  The tempo is increased (0.75) and a little overlap 
	put in (skiptime=0.5) to allow more entries within the times.
rem ndfmot4.txt
rem 59 60
rem #9				(Harmonic Field/Set, with changing times)
rem 0.0 1 60 0 0
rem 2.0 1 61 0 0
rem 2.0 1 63 0 0
rem 4.0 1 64 0 0
rem 4.0 1 66 0 0
rem 4.0 1 67 0 0
rem 6.0 1 68 0 0
rem 6.0 1 70 0 0
rem 6.0 1 72 0 0
rem #10				(motif 1)
rem 0.0 1 60 70 0.3
rem 0.1 1 61 50 0.3
rem 0.2 1 66 50 0.3
rem 0.3 1 67 50 0.3
rem 0.4 1 66 50 0.3
rem 0.5 1 67 70 0.3
rem 0.6 1 70 50 0.3
rem 0.7 1 66 50 0.3
rem 0.8 1 72 80 0.3
rem 0.9 1 66 60 0.3
rem #3				(motif 2)
rem 0.0  1 60 40 1.5
rem 0.34 1 67 45 1.5
rem 0.67 1 72 50 1.5

texture motifs 4 marimba horn motifex4 ndfmot4.txt 12 0.5 0 0  1 2 30 90 60 72 0 1 1 0 0  0.75 0.75

echo off

prompt $P$G


